jQuery(function($){
	
	if(esUsuarioModificacion){
		$('#MantPlantillas').rup_table({
			url: '../ab03b05t00',
			colNames: [
				$.rup.i18n.app.mantenimientos.id,
				$.rup.i18n.app.mantenimientos.nombrePlantilla
			],
			colModel: [
				{ 	name: 'id005', 
				 	label: 'id005',
				 	index: 'id005',
					align: 'center', 
					width: 50, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: 'nombre005', 
				 	label: 'nombre005',
				 	index: 'nombre005',
					align: '', 
					width: 150, 
					editable: false, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	        model: 'Ab03b05t00',
	        usePlugins:[
				'formEdit',
	        	'feedback',
				'toolbar',
	        	'contextMenu',
	        	'fluid',
	        	'filter'//,
	        	//'search'
	        ],
	        core: {
		        showOperations: {
		        	'delete': false,
		        	'add': false,
	        		'clone': false
		        }
	        },
			primaryKey: 'id005',
			sortname: 'id005',
			sortorder: 'asc',
			loadOnStartUp: true,
			feedback:{
				config:{
					block: false
				}
			},
			formEdit:{
	        	detailForm: '#MantPlantillas_detail_div',
				fillDataMethod: 'clientSide',
	    		addEditOptions:{
	    			reloadAfterSubmit:true
	    		},
	    		validate:{
	    			rules:{
	    				"file": { required: false }
	    			}
	    		}
	        }
		});
	}else{
		$('#MantPlantillas').rup_table({
			url: '../ab03b05t00',
			colNames: [
				$.rup.i18n.app.mantenimientos.id,
				$.rup.i18n.app.mantenimientos.nombrePlantilla
			],
			colModel: [
				{ 	name: 'id005', 
				 	label: 'id005',
				 	index: 'id005',
					align: 'center', 
					width: 50, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: 'nombre005', 
				 	label: 'nombre005',
				 	index: 'nombre005',
					align: '', 
					width: 150, 
					editable: false, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	        model: 'Ab03b05t00',
	        usePlugins:[
	        	'feedback',
	        	'fluid',
	        	'filter'
	        ],
	        core: {
		        showOperations: {
		        	'delete': false,
		        	'add': false,
	        		'clone': false
		        }
	        },
			primaryKey: 'id005',
			sortname: 'id005',
			sortorder: 'asc',
			loadOnStartUp: true,
			feedback:{
				config:{
					block: false
				}
			}
		});
	}
	
	$("#MantPlantillas_filter_form").rup_validate({
		feedback:$("#MantPlantillas_feedback"),
		liveCheckingErrors: false,
		rules:{
			"id005":{digits:true}
		}
	});	
	
	
	$("#MantPlantillas").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#MantPlantillas_filter_form"))){	
				return true;
			} else {
				return false;
			}
		}
	);	
	
	$('#MantPlantillas').on('jqGridAddEditAfterShowForm', function(event, savedData, newData) {
		$('#pag_MantPlantillas').css('display', 'none');
		$('#capaPlantilla').html($('#url').val());
		
		var texto=$("#ui-dialog-title-MantPlantillas_detail_div").html();
		if(texto=="Agregar registro"||texto=="Gehitu erregistroa"){
			$("#nombre005_detail_table").prop('readonly', false);
		}else{
			$("#nombre005_detail_table").prop('readonly', true);
		}
				
		if ($.browser.msie) {
			$('#file_form').replaceWith($('#file_form').clone());
		} else {
			$('#file_form').val('');
		}		 
				
		$('#MantPlantillas_detail_form').rup_validate({
			feedback: $('#MantPlantillas_detail_feedback'),
			liveCheckingErrors: true,
			showFieldErrorAsDefault: true,
			showErrorsInFeedback: true,
			showFieldErrorsInFeedback: true,
			rules:{
				"nombre005": { required: true },
				"file":{
				    required: function() {
				    	return $('#descargarPlantilla').data('hayPlantilla') != 'S'; 
				    }
	    		}
			}
		});
	});
	
	$("#MantPlantillas").on("rupTable_beforeAddRow", function(addOptions, selectedRow) {
		MantPlantillas_detail_form.reset();
		
		$("#descargarPlantilla").removeData("clonando");
		$('#descargarPlantilla').text('');
		$('#descargarPlantilla').unbind('click');
		$('#file_form').attr('required', true);
	});
		
	$('#MantPlantillas').on("rupTable_beforeEditRow", function(editOptions, selectedRow) {
		$("#descargarPlantilla").removeData("clonando");
		setTimeout(function() {
			if ($('#url').val() != '') {
				$('#file_form').removeAttr('required');
			}
		}, 500);
	});
	
	$("#MantPlantillas").on("rupTable_afterFormFillDataServerSide", function(event, savedData, newData){ 
		var texto=$("#ui-dialog-title-MantPlantillas_detail_div").html();
		if(texto=="Agregar registro"||texto=="Gehitu erregistroa"){
			$('#esAlta').val('S');
		}else{
			$('#esAlta').val('N');
		}
		
		$('#descargarPlantilla').text('');
		$('#descargarPlantilla').unbind('click');
		if (savedData['plantilla005'] != null) {
			var nombrePlantilla = savedData['nombre005'];
			var idPlantilla = savedData['id005'];
			$('#descargarPlantilla').text($.rup.i18n.app.mantenimientos.descargar);
			$('#descargarPlantilla').on('click', function() {
				downloadDocument('/ab03bAmiantoWar/ab03b05t00/download?plantilla=' + idPlantilla);
			});
			$('#descargarPlantilla').removeClass('sin-plantilla');
			$('#descargarPlantilla').data('hayPlantilla', 'S');
			if ($("#descargarPlantilla").data("clonando") == true){
				$("#plantillaBase64").val(savedData["plantilla005"]);
			}
			
		} else {
			$('#descargarPlantilla').text($.rup.i18n.app.mantenimientos.plantillaNoEncontrada);
			$('#descargarPlantilla').addClass('sin-plantilla');
			$('#descargarPlantilla').data('hayPlantilla', 'N');
			$("#plantillaBase64").val("");
		}
	});	
	
	$('#MantPlantillas').on("rupTable_beforeCloneRow", function(cloneOptions, selectedRow) {
		$("#descargarPlantilla").data("clonando", true);
	});
	
});

//Funcion limpiar
$('#MantPlantillas_filter_cleanLink').click(function(event){
	resetFiltro($("#MantPlantillas_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#MantPlantillas_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#MantPlantillas_feedback").rup_feedback("close");
	
	$("#MantPlantillas").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#MantPlantillas_filter_form")).remove();
});

function downloadDocument(url){
	var preparingFileModal = $("#preparing-file-modal");

    preparingFileModal.dialog({ modal: true });

    $.fileDownload(url, {
        successCallback: function (url) {
            preparingFileModal.dialog('close');
        },
        failCallback: function (responseHtml, url) {
            preparingFileModal.dialog('close');
            $("#error-modal").dialog({ modal: true });
        }
    });
    
}


